(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23951,        712]*)
(*NotebookOutlinePosition[     24854,        742]*)
(*  CellTagsIndexPosition[     24810,        738]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Examples 7.3", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Load the LPT.m package."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(<< Library/Mathematica/Applications/RossDE/LPT.m\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Example 6.11"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Transform the initial value problem."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Transform", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[DoublePrime]",
                    MultilineFunction->None], "[", "t", "]"}], "-", 
                RowBox[{"5", " ", 
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], 
                "+", \(6\ y[t]\)}], "==", \(Exp[2\ t]\)}], ",", \(y[0] == 1\),
             ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", \(-2\)}]}],
           "}"}], ",", "t", ",", "s"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          
          RowBox[{\(6\ LaplaceTransform[y[t], t, s]\), 
            "+", \(s\^2\ LaplaceTransform[y[t], t, s]\), 
            "-", \(5\ \((s\ LaplaceTransform[y[t], t, s] - y[0])\)\), 
            "-", \(s\ y[0]\), "-", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "0", "]"}]}], 
          "==", \(1\/\(\(-2\) + s\)\)}], ",", \(y[0] == 1\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", \(-2\)}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData["Isolate the thransform of the unknown function y[t]."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Isolate[%, y[t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({LaplaceTransform[y[t], t, 
          s] \[Rule] \(15 - 9\ s + s\^2\)\/\(\((\(-3\) + s)\)\ \((\(-2\) + s)\
\)\^2\)}\)], "Output"]
}, Open  ]],

Cell["Find the inverse transform.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseLaplaceTransform[%, s, t]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({y[t] \[Rule] 
        4\ \[ExponentialE]\^\(2\ t\) - 
          3\ \[ExponentialE]\^\(3\ t\) - \[ExponentialE]\^\(2\ t\)\ t}\)], \
"Output"]
}, Open  ]],

Cell[TextData["Capture the solution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(w[t_] = y[t] /. %\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4\ \[ExponentialE]\^\(2\ t\) - 
      3\ \[ExponentialE]\^\(3\ t\) - \[ExponentialE]\^\(2\ t\)\ t\)], "Output"]
}, Open  ]],

Cell[TextData["Re-state and name the initial value problem."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(sys[t_, y_]\), "=", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[DoublePrime]",
                  MultilineFunction->None], "[", "t", "]"}], "-", 
              RowBox[{"5", " ", 
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], 
              "+", \(6\ y[t]\)}], "==", \(Exp[2\ t]\)}], ",", \(y[0] == 1\), 
          ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "0", "]"}], "==", \(-2\)}]}], 
        "}"}]}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{\(6\ y[t]\), "-", 
            RowBox[{"5", " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], 
          "==", \(\[ExponentialE]\^\(2\ t\)\)}], ",", \(y[0] == 1\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", \(-2\)}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData["The equation and both initial conditions are correct."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[sys[t, w]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({True, True, True}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"LPTSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[DoublePrime]",
                    MultilineFunction->None], "[", "t", "]"}], "-", 
                RowBox[{"5", " ", 
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], 
                "+", \(6\ y[t]\)}], "==", \(Exp[2\ t]\)}], ",", \(y[0] == 1\),
             ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", \(-2\)}]}],
           "}"}], ",", \(y[t]\), ",", "t", ",", "s"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("The transformed system"\)], "Print"],

Cell[BoxData[
    \(2 - s + 6\ LaplaceTransform[y[t], t, s] + 
        s\^2\ LaplaceTransform[y[t], t, s] - 
        5\ \((\(-1\) + s\ LaplaceTransform[y[t], t, s])\) == 
      1\/\(\(-2\) + s\)\)], "Print"],

Cell[BoxData[
    \("The unknown(s) isolated."\)], "Print"],

Cell[BoxData[
    \({LaplaceTransform[y[t], t, 
          s] \[Rule] \(\(-7\) + 1\/\(\(-2\) + s\) + s\)\/\(6 - 5\ s + s\^2\)}\
\)], "Print"],

Cell[BoxData[
    \({y[t] \[Rule] \(-\[ExponentialE]\^\(2\ t\)\)\ \((\(-4\) + 
              3\ \[ExponentialE]\^t + t)\)}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example: 4th order IVP"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Transform the initial value problem.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Transform", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", 
                    TagBox[\((4)\),
                      Derivative],
                    MultilineFunction->None], "[", "t", "]"}], "-", 
                RowBox[{"8", " ", 
                  RowBox[{
                    SuperscriptBox["y", 
                      TagBox[\((3)\),
                        Derivative],
                      MultilineFunction->None], "[", "t", "]"}]}], "+", 
                RowBox[{"74", " ", 
                  RowBox[{
                    SuperscriptBox["y", "\[DoublePrime]",
                      MultilineFunction->None], "[", "t", "]"}]}], "-", 
                RowBox[{"232", " ", 
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], 
                "+", \(841\ y[t]\)}], "==", \(Exp[2\ t] - Cos[5\ t]\)}], 
            ",", \(y[0] == 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",",
             
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[DoublePrime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",",
             
            RowBox[{
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "0", "]"}], "==", "2"}]}], 
          "}"}], ",", "t", ",", "s"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          
          RowBox[{\(841\ LaplaceTransform[y[t], t, s]\), 
            "+", \(s\^4\ LaplaceTransform[y[t], t, s]\), 
            "-", \(232\ \((s\ LaplaceTransform[y[t], t, s] - y[0])\)\), 
            "-", \(s\^3\ y[0]\), "+", 
            RowBox[{"74", " ", 
              RowBox[{"(", 
                
                RowBox[{\(s\^2\ LaplaceTransform[y[t], t, s]\), 
                  "-", \(s\ y[0]\), "-", 
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "0", "]"}]}], ")"}]}], 
            "-", 
            RowBox[{\(s\^2\), " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}]}], "-", 
            RowBox[{"8", " ", 
              RowBox[{"(", 
                
                RowBox[{\(s\^3\ LaplaceTransform[y[t], t, s]\), 
                  "-", \(s\^2\ y[0]\), "-", 
                  RowBox[{"s", " ", 
                    RowBox[{
                      SuperscriptBox["y", "\[Prime]",
                        MultilineFunction->None], "[", "0", "]"}]}], "-", 
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]\[Prime]",
                      MultilineFunction->None], "[", "0", "]"}]}], ")"}]}], 
            "-", 
            RowBox[{"s", " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}]}], "-", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "0", "]"}]}], 
          "==", \(1\/\(\(-2\) + s\) - s\/\(25 + s\^2\)\)}], 
        ",", \(y[0] == 1\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "0", "]"}], "==", "2"}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData["Isolate the transform of the unknown function y[t]."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Isolate[%, y[t], t, s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({LaplaceTransform[y[t], t, 
          s] \[Rule] \(\(-230\) - 1\/\(2 - s\) + 74\ s - 8\ s\^2 + s\^3 - s\/\
\(25 + s\^2\)\)\/\(841 - 232\ s + 74\ s\^2 - 8\ s\^3 + s\^4\)}\)], "Output"]
}, Open  ]],

Cell["Find the inverse transform.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseLaplaceTransform[%, s, t]\)], "Input"],

Cell[BoxData[
    \({y[t] \[Rule] \[ExponentialE]\^\(2\ t\)\/625 + \
\(\[ExponentialE]\^\(\((2 - 5\ \[ImaginaryI])\)\ t\)\ \((\((3367092 - 1352125\
\ \[ImaginaryI])\) + \((3367092 + 1352125\ \[ImaginaryI])\)\ \
\[ExponentialE]\^\(10\ \[ImaginaryI]\ t\))\)\)\/6760000 + \(\(1\/52000\)\((\
\[ExponentialE]\^\(\((2 - 5\ \[ImaginaryI])\)\ t\)\ \((\(-5851\)\ \
\[ImaginaryI] + 
                  5851\ \[ImaginaryI]\ \[ExponentialE]\^\(10\ \[ImaginaryI]\ \
t\) + \((29255 + 75321\ \[ImaginaryI])\)\ t + \((29255 - 
                        75321\ \[ImaginaryI])\)\ \[ExponentialE]\^\(10\ \
\[ImaginaryI]\ t\)\ t)\))\)\) + \(12\ Cos[5\ t] + 5\ Sin[5\ t]\)\/5408}\)], \
"Output"]
}, Open  ]],

Cell[TextData["Capture the solution and recover the real form."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(w[t_] = ComplexExpand[y[t] /. %]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[ExponentialE]\^\(2\ t\)\/625 + \(3\ Cos[5\ t]\)\/1352 + \(841773\ \
\[ExponentialE]\^\(2\ t\)\ Cos[5\ t]\)\/1690000 + \(5851\ \
\[ExponentialE]\^\(2\ t\)\ t\ Cos[5\ t]\)\/10400 + \(841773\ \
\[ExponentialE]\^\(2\ t\)\ Cos[5\ t]\ Cos[10\ t]\)\/1690000 + \(5851\ \
\[ExponentialE]\^\(2\ t\)\ t\ Cos[5\ t]\ Cos[10\ t]\)\/10400 + \(5\ Sin[5\ t]\
\)\/5408 - \(422551\ \[ExponentialE]\^\(2\ t\)\ Sin[5\ t]\)\/1352000 + \
\(75321\ \[ExponentialE]\^\(2\ t\)\ t\ Sin[5\ t]\)\/52000 + \(422551\ \
\[ExponentialE]\^\(2\ t\)\ Cos[10\ t]\ Sin[5\ t]\)\/1352000 - \(75321\ \
\[ExponentialE]\^\(2\ t\)\ t\ Cos[10\ t]\ Sin[5\ t]\)\/52000 - \(422551\ \
\[ExponentialE]\^\(2\ t\)\ Cos[5\ t]\ Sin[10\ t]\)\/1352000 + \(75321\ \
\[ExponentialE]\^\(2\ t\)\ t\ Cos[5\ t]\ Sin[10\ t]\)\/52000 + \(841773\ \
\[ExponentialE]\^\(2\ t\)\ Sin[5\ t]\ Sin[10\ t]\)\/1690000 + \(5851\ \
\[ExponentialE]\^\(2\ t\)\ t\ Sin[5\ t]\ Sin[10\ t]\)\/10400 + \[ImaginaryI]\ \
\((\(-\(\(422551\ \[ExponentialE]\^\(2\ t\)\ Cos[
                      5\ t]\)\/1352000\)\) + \(75321\ \[ExponentialE]\^\(2\ t\
\)\ t\ Cos[5\ t]\)\/52000 + \(422551\ \[ExponentialE]\^\(2\ t\)\ Cos[5\ t]\ \
Cos[10\ t]\)\/1352000 - \(75321\ \[ExponentialE]\^\(2\ t\)\ t\ Cos[5\ t]\ \
Cos[10\ t]\)\/52000 - \(841773\ \[ExponentialE]\^\(2\ t\)\ Sin[5\ \
t]\)\/1690000 - \(5851\ \[ExponentialE]\^\(2\ t\)\ t\ Sin[5\ t]\)\/10400 - \
\(841773\ \[ExponentialE]\^\(2\ t\)\ Cos[10\ t]\ Sin[5\ t]\)\/1690000 - \
\(5851\ \[ExponentialE]\^\(2\ t\)\ t\ Cos[10\ t]\ Sin[5\ t]\)\/10400 + \
\(841773\ \[ExponentialE]\^\(2\ t\)\ Cos[5\ t]\ Sin[10\ t]\)\/1690000 + \
\(5851\ \[ExponentialE]\^\(2\ t\)\ t\ Cos[5\ t]\ Sin[10\ t]\)\/10400 + \
\(422551\ \[ExponentialE]\^\(2\ t\)\ Sin[5\ t]\ Sin[10\ t]\)\/1352000 - \
\(75321\ \[ExponentialE]\^\(2\ t\)\ t\ Sin[5\ t]\ Sin[10\ t]\)\/52000)\)\)], \
"Output"]
}, Open  ]],

Cell[TextData["Re-state and name the initial value problem."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(sys[t_, y_]\), "=", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((4)\),
                    Derivative],
                  MultilineFunction->None], "[", "t", "]"}], "-", 
              RowBox[{"8", " ", 
                RowBox[{
                  SuperscriptBox["y", 
                    TagBox[\((3)\),
                      Derivative],
                    MultilineFunction->None], "[", "t", "]"}]}], "+", 
              RowBox[{"74", " ", 
                RowBox[{
                  SuperscriptBox["y", "\[DoublePrime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "-", 
              RowBox[{"232", " ", 
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], 
              "+", \(841\ y[t]\)}], "==", \(Exp[2\ t] - Cos[5\ t]\)}], 
          ",", \(y[0] == 1\), ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[DoublePrime]",
                MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "0", "]"}], "==", "2"}]}], 
        "}"}]}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{\(841\ y[t]\), "-", 
            RowBox[{"232", " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{"74", " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "-", 
            RowBox[{"8", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((4)\),
                  Derivative],
                MultilineFunction->None], "[", "t", "]"}]}], 
          "==", \(\[ExponentialE]\^\(2\ t\) - Cos[5\ t]\)}], 
        ",", \(y[0] == 1\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "0", "]"}], "==", "2"}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[
"The equation and all initial conditions are satisfied. (This verification \
takes a LONG time.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[sys[t, w]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({True, True, True, True, True}\)], "Output"]
}, Open  ]],

Cell[TextData["Solve the system in a single step."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"LPTSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", 
                    TagBox[\((4)\),
                      Derivative],
                    MultilineFunction->None], "[", "t", "]"}], "-", 
                RowBox[{"8", " ", 
                  RowBox[{
                    SuperscriptBox["y", 
                      TagBox[\((3)\),
                        Derivative],
                      MultilineFunction->None], "[", "t", "]"}]}], "+", 
                RowBox[{"74", " ", 
                  RowBox[{
                    SuperscriptBox["y", "\[DoublePrime]",
                      MultilineFunction->None], "[", "t", "]"}]}], "-", 
                RowBox[{"232", " ", 
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], 
                "+", \(841\ y[t]\)}], "==", \(Exp[2\ t] - Cos[5\ t]\)}], 
            ",", \(y[0] == 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",",
             
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[DoublePrime]",
                  MultilineFunction->None], "[", "0", "]"}], "==", "0"}], ",",
             
            RowBox[{
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "0", "]"}], "==", "2"}]}], 
          "}"}], ",", \(y[t]\), ",", "t", ",", "s"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("The transformed system"\)], "Print"],

Cell[BoxData[
    \(\(-2\) - s\^3 + 841\ LaplaceTransform[y[t], t, s] + 
        s\^4\ LaplaceTransform[y[t], t, s] - 
        232\ \((\(-1\) + s\ LaplaceTransform[y[t], t, s])\) + 
        74\ \((\(-s\) + s\^2\ LaplaceTransform[y[t], t, s])\) - 
        8\ \((\(-s\^2\) + s\^3\ LaplaceTransform[y[t], t, s])\) == 
      1\/\(\(-2\) + s\) - s\/\(25 + s\^2\)\)], "Print"],

Cell[BoxData[
    \("The unknown(s) isolated."\)], "Print"],

Cell[BoxData[
    \({LaplaceTransform[y[t], t, 
          s] \[Rule] \(\(-230\) + 1\/\(\(-2\) + s\) + 74\ s - 8\ s\^2 + s\^3 \
- s\/\(25 + s\^2\)\)\/\(841 - 232\ s + 74\ s\^2 - 8\ s\^3 + s\^4\)}\)], \
"Print"],

Cell[BoxData[
    \({y[t] \[Rule] \(\(1\/6760000\)\((\[ExponentialE]\^\(\(-5\)\ \
\[ImaginaryI]\ t\)\ \((\((7500 + 
                    3125\ \[ImaginaryI])\) + \((7500 - 
                      3125\ \[ImaginaryI])\)\ \[ExponentialE]\^\(10\ \
\[ImaginaryI]\ t\) + 
                10816\ \[ExponentialE]\^\(\((2 + 5\ \[ImaginaryI])\)\ t\) + \
\((5 + 12\ \[ImaginaryI])\)\ \[ExponentialE]\^\(2\ t\)\ \((\((\(-50400\) - 
                          301591\ \[ImaginaryI])\) + \((807790 + 
                            19650\ \[ImaginaryI])\)\ t)\) + \[ExponentialE]\^\
\(\((2 + 10\ \[ImaginaryI])\)\ t\)\ \((\((3367092 + 
                          2112755\ \[ImaginaryI])\) + \((3803150 - 
                            9791730\ \[ImaginaryI])\)\ t)\))\))\)\)}\)], \
"Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example (Apart)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apart[1\/\(s\ \((1 + s\^2)\)\), s]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/s - s\/\(1 + s\^2\)\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example (InverseLaplaceTransform)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseLaplaceTransform[1\/s - s\/\(1 + s\^2\), s, t]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1 - Cos[t]\)], "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{28, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 80, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1859, 57, 97, 2, 32, "Text",
  Evaluatable->False],
Cell[1959, 61, 107, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[2091, 67, 89, 2, 56, "Section",
  Evaluatable->False],
Cell[2183, 71, 110, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2318, 77, 828, 21, 43, "Input"],
Cell[3149, 100, 671, 17, 102, "Output"]
}, Open  ]],
Cell[3835, 120, 126, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3986, 126, 81, 2, 27, "Input"],
Cell[4070, 130, 149, 3, 47, "Output"]
}, Open  ]],
Cell[4234, 136, 91, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4350, 142, 91, 2, 27, "Input"],
Cell[4444, 146, 161, 4, 29, "Output"]
}, Open  ]],
Cell[4620, 153, 95, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4740, 159, 76, 2, 27, "Input"],
Cell[4819, 163, 131, 2, 29, "Output"]
}, Open  ]],
Cell[4965, 168, 118, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5108, 174, 754, 20, 43, "Input"],
Cell[5865, 196, 663, 17, 29, "Output"]
}, Open  ]],
Cell[6543, 216, 127, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6695, 222, 78, 2, 27, "Input"],
Cell[6776, 226, 52, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6865, 232, 842, 21, 43, "Input"],
Cell[7710, 255, 57, 1, 23, "Print"],
Cell[7770, 258, 207, 4, 74, "Print"],
Cell[7980, 264, 59, 1, 23, "Print"],
Cell[8042, 267, 140, 3, 46, "Print"],
Cell[8185, 272, 136, 2, 29, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[8370, 280, 99, 2, 36, "Section",
  Evaluatable->False],
Cell[8472, 284, 100, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8597, 290, 1772, 45, 86, "Input"],
Cell[10372, 337, 2399, 60, 165, "Output"]
}, Open  ]],
Cell[12786, 400, 125, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12936, 406, 81, 2, 27, "Input"],
Cell[13020, 410, 203, 3, 76, "Output"]
}, Open  ]],
Cell[13238, 416, 91, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13354, 422, 65, 1, 27, "Input"],
Cell[13422, 425, 671, 11, 177, "Output"]
}, Open  ]],
Cell[14108, 439, 121, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14254, 445, 91, 2, 27, "Input"],
Cell[14348, 449, 1841, 26, 564, "Output"]
}, Open  ]],
Cell[16204, 478, 118, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16347, 484, 1628, 42, 84, "Input"],
Cell[17978, 528, 1504, 40, 47, "Output"]
}, Open  ]],
Cell[19497, 571, 170, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19692, 579, 78, 2, 27, "Input"],
Cell[19773, 583, 64, 1, 27, "Output"]
}, Open  ]],
Cell[19852, 587, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19985, 593, 1786, 45, 86, "Input"],
Cell[21774, 640, 57, 1, 23, "Print"],
Cell[21834, 643, 370, 6, 110, "Print"],
Cell[22207, 651, 59, 1, 23, "Print"],
Cell[22269, 654, 209, 4, 72, "Print"],
Cell[22481, 660, 769, 13, 126, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[23299, 679, 92, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[23416, 685, 93, 2, 44, "Input"],
Cell[23512, 689, 56, 1, 42, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[23617, 696, 110, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[23752, 702, 112, 2, 42, "Input"],
Cell[23867, 706, 44, 1, 27, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

Output"]
}, Closed]],
Cell[17099, 497, 118, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[17240, 501, 1628, 42, 70, "Input"],
Cell[18871, 545, 1525, 41, 70, "Output"]
}, Closed]],
Cell[20408, 588, 170, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[20601, 594, 78, 2, 70, "Input"],
Cell[20682, 598, 112, 3, 70, "Output"]
}, Closed]],
Cell[20806, 603, 108, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[20937, 607, 1786, 45, 70, "Input"],
Cell[22726, 654, 1083, 16, 70, "Print"],
Cell[23812, 672, 615, 14, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24468, 688, 92, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[24583, 692, 93, 2, 70, "Input"],
Cell[24679, 696, 104, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24824, 701, 110, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[24957, 705, 112, 2, 70, "Input"],
Cell[25072, 709, 92, 3, 70, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
